


export class ArticleEditWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/sales/article/')}}" class="fa fa-chevron-circle-left"></a>
				<span ez-if="isNew == false">
					<a href="javascript:void(0);" [onclick]="widget.deleteArticle" class="fa fa-trash"></a>
				</span>
				<a href="javascript:void(0);" [onclick]="widget.saveArticle" class="fa fa-save"></a>
			</div>
			<h1>{{isNew?'Nieuw artikel':'Bewerk artikel'}}</h1>
		</div>
		
		<div ez-if="loading">
			Loading...
		</div>
		<div ez-if="!loading">
			<form id="frmArticle" action="{{appUrl('/service/sales/article.do')}}">
				<input type="hidden" name="a" value="save" />
				
				<input type="hidden" name="articleId" value="{{art.articleId}}" />
				
				<ez-checkbox name="active" label="Actief" [checked]="art.active"></ez-checkbox>
				
				<ez-text name="shortDescription" label="Naam" [value]="art.shortDescription"></ez-text>
				
				<ez-checkbox name="rentable" label="Verhuur" [checked]="art.rentable"></ez-checkbox>
				
				<ez-checkbox name="overbookable" label="Overboekbaar" [checked]="art.overbookable"></ez-checkbox>
				
				<ez-number name="maxBookable" label="Max. boekbaar" [value]="art.maxBookable"></ez-number>
				
				<ez-radio name="pricingMethod" [value]="art.pricingMethod" label="Prijsmethodiek">
					<option value="">Vaste prijs</option>
					<option value="hour">Per uur</option>
					<option value="week">Per week</option>
					<option value="month">Per maand</option>
					<option value="slotplan">Slotplanning</option>
					<option value="dayprice">Dagprijzen</option>
				</ez-radio>
				
				<ez-text name="price" class="format-price" label="{{ _('priceLabel.'+salesSettings.inputPrice) }}" [value]="art.displayPrice"></ez-text>
				
				<ez-select name="vatId" label="Btw tarief" [value]="art.vatId" [options]="vatOptions"></ez-select>
				
				
<!--				<ez-textarea name="longDescription" label="Lange omschrijving" [value]="art.longDescription"></ez-textarea> -->
				
<!--				<ez-datetime-text label="Bewerkt op" hideempty="1" [value]="art.edited"></ez-datetime-text> -->
				
<!--				<ez-datetime-text label="Aangemaakt op" hideempty="1" [value]="art.created"></ez-datetime-text> -->
			
			
				<div class="accordion">
					
					<div class="accordion-item accordion-item-slotplan">
						<h2 class="accordion-header"><button type="button" data-bs-toggle="collapse" data-bs-target="#slotprices" class="accordion-button">Slotplan prijzen</button></h2>
						<div id="slotprices" class="accordion-collapse show">
							<div class="accordion-body">
								
								<ez-select name="slotplanId" label="Slotplan" [value]="art.slotplanId" [options]="slotplanOptions"></ez-select>
								
								<ul ez-for="pricetypes" ez-item="pt">
									<li class="slotplan-pricetype">
										<div style="display: flex;">
											<ez-text class="format-price" pricetype-id="{{pt.slotplanPricetypeId}}" name="pricetype-{{pt.slotplanPricetypeId}}" label="{{pt.name}}"></ez-text>
										
											&nbsp; {{ _('priceLabel.'+salesSettings.inputPrice) }}
										</div>
									</li>
								</ul>
								
							</div>
						</div>
					</div>
					
					<div class="accordion-item accordion-item-dayprices">
						<h2 class="accordion-header"><button type="button" data-bs-toggle="collapse" data-bs-target="#dayprices" class="accordion-button">Dagprijzen</button></h2>
						<div id="dayprices" class="accordion-collapse show">
							<div class="accordion-body">
								
								<ez-select name="daypriceId" label="{{_('Day price')}}" [value]="art.daypriceId" [options]="daypriceOptions"></ez-select>
								
							</div>
						</div>
					</div>
					
					
					<div class="accordion-item" ez-if="groups.length > 0">
						<h2 class="accordion-header"><button type="button" data-bs-toggle="collapse" data-bs-target="#articleGroups" class="accordion-button">Groepen</button></h2>
						<div id="articleGroups" class="accordion-collapse show">
							<div class="accordion-body">
							
								<table class="table table-groups">
									<thead>
										<tr>
											<th>Groepnaam</th>
											<th>Geselecteerd</th>
											<th>Hoofdgroep</th>
										</tr>
									</thead>
									<tbody id="tbody-groups" ez-for="groups" ez-item="g">
										<tr class="tr-group">
											<td>
												{{g.groupName}}
											</td>
											<td>
												<input type="checkbox" 
														class="link-ag" 
														name="linked_ag_{{g.articleGroupId}}" 
														[checked]="{{ art.articleGroupIds.indexOf(g.articleGroupId) != -1 }}"
														value="{{g.articleGroupId}}" />
											</td>
											<td>
												<input type="radio" 
														id="main_article_group_id-{{g.articleGroupId}}" 
														name="main_article_group_id" 
														[checked]="{{ art.mainArticleGroupId == g.articleGroupId }}"
														value="{{g.articleGroupId}}" />
											</td>
										</tr>
									</tbody>
								</table>
							
							</div>
						</div>
					</div>
					
				</div>
			</form>
			
		</div>
	`;
	
	
	container = null;
	loading = true;
	
	salesSettings = [];
	vatOptions = null;
	groups = [];
	slotplans = null;
	pricetypes = [];
	dayprices = [];
	
	ezTpl = null;
	articleId = null;
	art = {
		shortDescription: '',
		active: true,
		articleGroupIds: []
	};
	
	isNew = false;
	
	init(e) {
		this.container = e;
		
		let id = getUrlParam('id');
		
		if (id) {
			this.articleId = id;
		}
		
		this.loadConfig();
		
		this.render();
	}
	
	toggleSettings() {
		if ( $('input[name=rentable]').prop('checked') ) {
			$('ez-checkbox[name=overbookable]').show();
			
			if ($('input[name=overbookable]').prop('checked')) {
				$('ez-number[name=maxBookable]').show();
			}
			else {
				$('ez-number[name=maxBookable]').hide();
			}
		}
		else {
			$('ez-checkbox[name=overbookable]').hide();
			$('ez-number[name=maxBookable]').hide();
		}
	}
	
	togglePricingMethodSettings() {
		let pricingMethod = $('input[type=radio][name=pricingMethod]:checked').val();
		
		// default
		$('ez-text[name=price]').show();
		$('.accordion-item-slotplan').hide();
		$('.accordion-item-dayprices').hide();
		
		if (pricingMethod == 'slotplan') {
			$('ez-text[name=price]').hide();
			$('.accordion-item-slotplan').show();
		}
		else if (pricingMethod == 'dayprice') {
			$('ez-text[name=price]').hide();
			$('.accordion-item-dayprices').show();
		}
	}
	
	
	toggleGroupSettings() {
		$('#tbody-groups .tr-group').each(function(index, node) {
			let c = $(node).find('input.link-ag').prop('checked');
			
			if (c) {
				$(node).find('input[type=radio]').removeAttr('disabled');
				
				// none Main-group checked?
				if ( $(node).closest( '#tbody-groups' ).find('input[type=radio]:checked').length == 0 ) {
					$(node).find('input[type=radio]').prop('checked', true);
				}
			}
			else {
				$(node).find('input[type=radio]').prop('checked', false);
				$(node).find('input[type=radio]').attr('disabled', 'disabled');
			}
			
		})
	}
	
	
	lookupSlotplanById( slotplanId ) {
		for(let i in this.slotplans) {
			if (this.slotplans[i].slotplanId == slotplanId)
				return this.slotplans[i];
		}
		return null;
	}
	
	toggleSlotplanSettings() {
		
		$('.slotplan-pricetype').hide();
		
		let slotplanId = $('select[name=slotplanId]').val();
		
		let slotplan = this.lookupSlotplanById( slotplanId );
		
		if (!slotplan)
			return;
		
		console.log(slotplan);
		
		$('.slotplan-pricetype ez-text').each(function(index, node) {
			let ptid = $(node).attr('pricetype-id');
//			console.log(ptid, slotplan.pricetypes);
			for(let i in slotplan.pricetypes) {
				if (slotplan.pricetypes[i].slotplanPricetypeId == ptid) {
					$(node).closest('.slotplan-pricetype').show();
				}
			}
		});
		
		
	}
	
	
	
	async loadConfig() {
		let configResponse = await postUrl('/service/sales/article.do', {
			a: 'config'
		});
		
		let json = await configResponse.json();
		
		this.salesSettings = json.salesSettings;
		this.vatOptions    = json.vats;
		this.groups        = json.groups;
		this.slotplans     = json.slotplans;
		this.pricetypes    = json.pricetypes;
		this.dayprices     = json.dayprices;
		
		if (this.articleId) {
			this.loadArticle( this.articleId );
		}
		else {
			this.loading = false;
			this.render();
		}
		
	}
	
	listVatOptions() {
		let l = [];
		
		for(let i in this.vatOptions) {
			l.push({
				description: this.vatOptions[i].description,
				value: this.vatOptions[i].vatId,
				visible: this.vatOptions[i].visible
			});
		}
		
		return l;
	}
	
	listSlotplanOptions() {
		let r = [];
		for(let i in this.slotplans) {
			let sp = this.slotplans[i];
			
			r.push ({
				value: sp.slotplanId,
				text: sp.name
			});
			
		}
		return r;
	}
	
	listDaypriceOptions() {
		let r = [];
		for(let i in this.dayprices) {
			let dp = this.dayprices[i];
			
			r.push({
				value: dp.daypriceId,
				text: dp.name
			});
		}
		return r;
	}
	
	
	render() {
//		console.log( this.tpl );
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setVar('loading',    this.loading);
		this.ezTpl.setVar('art',        this.art);
		this.ezTpl.setVar('groups',     this.groups);
		this.ezTpl.setVar('vatOptions', this.listVatOptions());
		this.ezTpl.setVar('slotplanOptions', this.listSlotplanOptions());
		this.ezTpl.setVar('daypriceOptions', this.listDaypriceOptions());
		this.ezTpl.setVar('salesSettings', this.salesSettings);
		this.ezTpl.setVar('pricetypes', this.pricetypes);
		
		this.ezTpl.setVar('isNew',      this.isNew);
		this.ezTpl.setObject('widget',  this);
		this.ezTpl.render();
		
		this.toggleSettings();
		
		
		$('#tbody-groups input[type=checkbox]').on('change', this.toggleGroupSettings);
		this.toggleGroupSettings();
		
		$('#tbody-groups input[type=checkbox]').on('change', this.toggleGroupSettings);
		this.toggleGroupSettings();
		
		
		$('#frmArticle').find('input[name=rentable], input[name=overbookable]').on('change', function() {
			this.toggleSettings();
		}.bind(this));
		
		
		$('#frmArticle').find('ez-radio[name=pricingMethod] input[type=radio]').on('change', function() {
			this.togglePricingMethodSettings();
		}.bind(this));
		this.togglePricingMethodSettings();
		
		$('select[name=slotplanId]').on('change', function() { this.toggleSlotplanSettings(); }.bind(this));
		this.toggleSlotplanSettings();
		
		
		focusFirstField( '#frmArticle' );
	}
	
	
	saveArticle() {
		if (this.loading) {
			return;
		}
		
		this.loading = true;
		
		postForm('#frmArticle').then(async function(e) {
			
			let json = await e.json();
			console.log( json );
			
			if (json.error) {
				// TODO: render errors
				formShowErrors( '#frmArticle', json );
				
			}
			else {
				// report succesfully saved
				reportUserMessage( 'Wijzigingen opgeslagen' );
				
				// reload data?
				gotoRoute( '/masterdata/sales/article/edit/?id='+json.articleId );
			}
			
			this.loading = false;
		}.bind(this)).catch(showErrorWidget);
	}
	
	deleteArticle() {
		showConfirmation('Verwijderen', 'Weet je zeker dat je dit artikel wilt verwijderen?', function() {
			
			postUrl( '/service/sales/article.do', {
				a: 'delete',
				articleId: this.art.articleId
			}).then( async function(e) {
				let json = await e.json();
				if (json.error) {
					showAlert('Error', 'Error: ' + e.message);
					return;
				}
				
				gotoRoute( '/masterdata/sales/article/' );
			}.bind(this));
			
		}.bind(this));
	}
	
	
	
	loadArticle(articleId) {
		postUrl( '/service/sales/article.do', {
			a: 'view',
			articleId: articleId
		}).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget(json);
			}
			
			this.loading = false;
			
			this.art = json.article;
			
			if (this.salesSettings.inputPrice == 'excl_vat') {
				this.art.displayPrice = this.art.priceExclVat;
			}
			else if (this.salesSettings.inputPrice == 'incl_vat') {
				this.art.displayPrice = this.art.priceInclVat;
			}
			
			this.render();
			
			$('input[name=price]').trigger( 'change' );			// formats price
			
			for(let i in this.art.slotplanPrices) {
				let sp = this.art.slotplanPrices[i];
				
				if (this.salesSettings.inputPrice == 'excl_vat') {
					$('input[name=pricetype-' + sp.slotplanPricetypeId+']').val( format_price(sp.priceExclVat, 1) );
				}
				else if (this.salesSettings.inputPrice == 'incl_vat') {
					$('input[name=pricetype-' + sp.slotplanPricetypeId+']').val( format_price(sp.priceInclVat, 1) );
				}
			}
			
		}.bind(this)  );
	}
	
}


